package cn.com.servyou.rmi;

import cn.com.servyou.utils.DependUtil;
import cn.com.servyou.utils.LoggerUtil;
import lombok.extern.slf4j.Slf4j;

/**
 * 请求管理工厂
 *
 * @author zhouww
 * @since 20191024
 */
@Slf4j
public class InvokeManageFactory {

    public static InvokeManage create() {
        if (DependUtil.checkOkHttp3()) {
            LoggerUtil.info(log, "[网络请求]使用Okhttp");
            return new OkHttpInvokeManageImpl();
        } else if (DependUtil.checkSpringWeb()) {
            LoggerUtil.info(log, "[网络请求]使用RestTemplate");
            return new SpringInvokeManageImpl();
        }
        throw new RuntimeException("没有网络组件, 支持RestTemplate和OkHttp3");
    }
}
