package cn.com.servyou.rmi;

import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.utils.LoggerUtil;
import cn.com.servyou.utils.MapUtil;
import lombok.extern.slf4j.Slf4j;
import okhttp3.Call;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.TimeUnit;

/**
 * @author zhouww
 * @since 20191024
 */
@Slf4j
public class OkHttpInvokeManageImpl implements InvokeManage {

    OkHttpClient okHttpClient;

    public OkHttpInvokeManageImpl() {
        okHttpClient = new OkHttpClient.Builder()
                .connectTimeout(30, TimeUnit.SECONDS)
                .callTimeout(120, TimeUnit.SECONDS)
                .readTimeout(300, TimeUnit.SECONDS)
                .build();
    }

    @Override
    public byte[] request(RequestMethod method, String url, Map<String, String> headers, String body) throws MalformedURLException {
        Headers.Builder okHttpHeadersBuilder = new Headers.Builder();
        if (MapUtil.isNotEmpty(headers)) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                okHttpHeadersBuilder.add(header.getKey(), header.getValue());
            }
        }

        String contentType = headers.get("Content-Type");
        RequestBody requestBody = null;
        if (null != body) {
            requestBody = RequestBody.create(MediaType.parse(contentType), body);
        }

        Request request = new Request.Builder()
                .method(method.name(), requestBody)
                .url(new URL(url))
                .headers(okHttpHeadersBuilder.build())
                .build();
        Call call = okHttpClient.newCall(request);
        try {
            Response response = call.execute();
            LoggerUtil.info(log, "[请求traceId={0}]", response.header("traceId"));
            return response.body().bytes();
        } catch (IOException e) {
            LoggerUtil.error(log, e, "OkHttp 请求异常");
            throw new RuntimeException(e);
        }
    }
}
