package cn.com.servyou.rmi;

import lombok.extern.slf4j.Slf4j;

/**
 * 服务管理工厂
 *
 * @author zhouww
 * @since 20191024
 */
@Slf4j
public class ServerManageFactory {

    /**
     * 创建服务管理类
     *
     * @param environmental environmental
     * @return 服务管理
     */
    public static ServerManage create(String environmental) {
        return new ServerManageImpl(environmental);
    }

    /**
     * 创建服务管理类
     *
     * @param environmental environmental
     * @return 服务管理
     */
    public static ServerManage create(String environmental, String url) {
        return new ServerManageImpl(environmental, url);
    }
}
