package cn.com.servyou.rmi;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.utils.StringUtil;
import lombok.extern.slf4j.Slf4j;

import java.util.HashMap;
import java.util.Map;

/**
 * 服务管理实现
 *
 * @author zhouww
 * @since 20191024
 */
@Slf4j
public class ServerManageImpl implements ServerManage {
    /**
     * 服务列表
     * 服务名字--服务器地址
     */
    private Map<String, String> serverMap = new HashMap<>();

    private String environmental;

    /**
     * 客户使用指定url的方式
     *
     * @param environmental 环境名
     * @param url 显示指定url
     */
    public ServerManageImpl(String environmental, String url) {
        this.environmental = environmental;
        serverMap.put(RMIConstant.SERVER_KEY_NAME, url);
    }

    /**
     * 指定配置文件
     *
     * @param environmental environmental
     */
    public ServerManageImpl(String environmental) {
        this.environmental = environmental;
        init();
    }

    public void init() {
        if (StringUtil.isBlank(environmental)) {
            return;
        }
        if (RMIConstant.TEST.equalsIgnoreCase(environmental)) {
            serverMap.put(RMIConstant.SERVER_KEY_NAME, RMIConstant.TEST_SERVICE);
        } else if (RMIConstant.PROD.equalsIgnoreCase(environmental)) {
            serverMap.put(RMIConstant.SERVER_KEY_NAME, RMIConstant.PROD_SERVICE);
        }
    }

    /**
     * 增加服务器配置
     *
     * @param serverName 服务名称
     * @param host       主机
     */
    @Override
    public void addServerConfig(String serverName, String host) {
        serverMap.put(serverName, host);
    }

    @Override
    public String getHost(String hostname) {
        return serverMap.get(hostname);
    }
}
