package cn.com.servyou.rmi;

import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.utils.LoggerUtil;
import cn.com.servyou.utils.MapUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.http.client.SimpleClientHttpRequestFactory;
import org.springframework.web.client.RestTemplate;

import java.net.URI;
import java.util.Map;

/**
 * 请求管理实现
 *
 * @author zhouww
 * @since 20191024
 */
@Slf4j
public class SpringInvokeManageImpl implements InvokeManage {
    // spring 提供的Rest类
    private RestTemplate restTemplate;

    public SpringInvokeManageImpl() {
        SimpleClientHttpRequestFactory simpleClientHttpRequestFactory = new SimpleClientHttpRequestFactory();
        simpleClientHttpRequestFactory.setConnectTimeout(30000);
        simpleClientHttpRequestFactory.setReadTimeout(300000);
        restTemplate = new RestTemplate(simpleClientHttpRequestFactory);
    }

    @Override
    public byte[] request(RequestMethod method, String url, Map<String, String> headers, String body) {
        HttpEntity httpEntity;
        if (MapUtil.isEmpty(headers)) {
            httpEntity = new HttpEntity(headers);
        } else {
            httpEntity = new HttpEntity(body, parseHeaders(headers));
        }

        try {
            ResponseEntity<byte[]> responseEntity = restTemplate.exchange(new URI(url), parseMethod(method), httpEntity, byte[].class);
            return responseEntity.getBody();
        } catch (Exception e) {
            LoggerUtil.error(log, e, "请求发生错误");
            throw new RuntimeException(e);
        }
    }

    private HttpMethod parseMethod(RequestMethod method) {
        return HttpMethod.resolve(method.name());
    }

    private HttpHeaders parseHeaders(Map<String, String> headerMap) {
        HttpHeaders httpHeaders = new HttpHeaders();
        if(MapUtil.isEmpty(headerMap)) {
            return httpHeaders;
        }
        for (Map.Entry<String, String> header : headerMap.entrySet()) {
            if ("Content-Type".toLowerCase().equals(header.getKey().toLowerCase())) {
                httpHeaders.add(header.getKey(), header.getValue() + ";charset=UTF-8");
            } else {
                httpHeaders.add(header.getKey(), header.getValue());
            }
        }
        return httpHeaders;
    }

    /**
     * 获取一次body
     * @param bodyMap bodyMap
     * @return 一个值
     */
    private Object getBody(Map<String, Object> bodyMap) {
        for (Map.Entry<String, Object> entry : bodyMap.entrySet()) {
            return entry.getValue();
        }
        return null;
    }
}
