package cn.com.servyou.rmi.http;

/**
 * @author zhouww
 * @since 20210624
 */
public enum MimeEnum {

    APPLICATION_JSON("application/json", "json格式"),

    APPLICATION_FROM_URLENCODED("application/x-www-from-urlencoded", "表单格式-url参数"),
    ;

    private String type;

    private String desc;

    MimeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public static MimeEnum getByCode(String type) {
        for (MimeEnum obj : MimeEnum.values()) {
            if (obj.type.equals(type)) {
                return obj;
            }
        }
        return null;
    }


    public String getType() {
        return type;
    }

    public String getDesc() {
        return desc;
    }
}
