package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.backup.BackupDeclareDataRequestVO;
import cn.com.servyou.dto.backup.BackupDeclareDataResultVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

/**
 * 申报数据备份
 *
 * @author ranjh
 * @since 20240524
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface BackupDeclareDataRequest {

    /**
     * 申报数据备份
     *
     * @param request request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/declareData/backup", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<AsyncResult> declareDataBackup(@JSONRequestBody BackupDeclareDataRequestVO request);

    /**
     * 获取申报数据备份反馈
     *
     * @param requestId requestId
     * @return
     */
    @RequestMapping(value = "/gateway/iit/declareData/getBackupFeedback", method = RequestMethod.GET)
    ApiResponse<BackupDeclareDataResultVO> getBackupFeedback(@RequestParam("requestId") String requestId);

}
