package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.BaseRequest;
import cn.com.servyou.dto.payment.CommissionCancelRequest;
import cn.com.servyou.dto.payment.CommissionCancelResult;
import cn.com.servyou.dto.payment.CommissionConfirmRequest;
import cn.com.servyou.dto.payment.CommissionConfirmResult;
import cn.com.servyou.dto.payment.CommissionQueryResultVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;

/**
 * @author ranjh
 * @since 20220623
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface CommissionRequest {

    /**
     * 查询手续费退税信息
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/payment/commission/query", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<CommissionQueryResultVO> queryCommission(@JSONRequestBody BaseRequest request);

    /**
     * 确认退付手续费
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/payment/commission/confirm", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<CommissionConfirmResult> confirm(@JSONRequestBody CommissionConfirmRequest request);

    /**
     * 撤销退费申请
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/payment/commission/cancel", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<CommissionCancelResult> cancel(@JSONRequestBody CommissionCancelRequest request);

}
