package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.common.SecondaryRequestVO;
import cn.com.servyou.dto.common.SecondaryResultVO;
import cn.com.servyou.dto.common.UpdatePasswordRequestVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 通用请求
 *
 * @author zhouww
 * @since 20210422
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface CommonRequest {

    /**
     * 密码修改
     *
     * @param request request
     * @return 请求结果
     */
    @RequestMapping(value = "/gateway/pts/iit/common/updatePassword", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse updatePassword(@JSONRequestBody UpdatePasswordRequestVO request);

    /**
     * 获取免税附表
     *
     * @param secondaryRequestVO
     * @return
     */
    @RequestMapping(value = "/gateway/iit/secondary/query", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<SecondaryResultVO> secondaryQuery(@RequestBody SecondaryRequestVO secondaryRequestVO);
}
