package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.BaseRequest;
import cn.com.servyou.dto.company.CompanyRegisterRequest;
import cn.com.servyou.dto.company.CompanyRegisterResponse;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;

import java.util.List;

/**
 * 企业请求接口
 *
 * @author zhouww
 * @since 20191024
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface CompanyRequest {

    /**
     * 企业登记以及查询
     *
     * @param request request
     * @return json字符串
     */
    @RequestMapping(value = "/gateway/iit/declare/getCompanyRegisterInfo", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<List<CompanyRegisterResponse>> getCompany(@JSONRequestBody CompanyRegisterRequest request);

    /**
     * 企业登记以及查询
     *
     * @param request request
     * @return json字符串
     */
    @RequestMapping(value = "/gateway/ets/iit/declare/getCompanyRegisterInfo", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<List<CompanyRegisterResponse>> getCompanyEts(@JSONRequestBody CompanyRegisterRequest request);

    /**
     * 密码校验
     *
     * @param request request
     * @return json字符串
     */
    @RequestMapping(value = "/gateway/iit/check/checkPassword", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse checkPassword(@JSONRequestBody BaseRequest request);

}
