package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.declare.DeclarationExportRequestVO;
import cn.com.servyou.dto.declare.DeclarationExportResultVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

/**
 * @author ranjh
 * @since 20240509
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface DeclarationExportRequest {

    /**
     * 标准表样、大厅表样导出接口-发起
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/pts/wrt/report/exportTableStyleAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<AsyncResult> exportTableStyleAsync(@JSONRequestBody DeclarationExportRequestVO request);

    /**
     * 标准表样、大厅表样导出接口-反馈
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/pts/wrt/report/exportTableStyleFeedback", method = RequestMethod.GET)
    ApiResponse<DeclarationExportResultVO> exportTableStyleFeedback(@RequestParam("requestId") String requestId);
}
