package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.BaseRequest;
import cn.com.servyou.dto.declare.CompanyDeclareRequest;
import cn.com.servyou.dto.declare.CompanyIncomeQueryRequest;
import cn.com.servyou.dto.declare.DataImportFeedback;
import cn.com.servyou.dto.declare.DeclareCancelRequest;
import cn.com.servyou.dto.declare.DeclareCorrectRequest;
import cn.com.servyou.dto.declare.DownloadAuthenticationStateRequest;
import cn.com.servyou.dto.declare.DownloadAuthenticationStateResultVO;
import cn.com.servyou.dto.declare.Feedback;
import cn.com.servyou.dto.declare.QueryDeclarationRecordDTO;
import cn.com.servyou.dto.tax.CalculateTaxResultRequest;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

import java.util.List;

/**
 * 申报请求接口
 *
 * @author zhouww
 * @since 20190829
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface DeclarationRequest {

    /**
     * 申报数据报送
     *
     * @param request request
     * @return json字符串
     */
    @RequestMapping(value = "/gateway/iit/report/send", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> send(@JSONRequestBody CompanyDeclareRequest request);

    /**
     * 申报数据反馈
     * @param requestId requestId
     * @return  json字符串
     */
    @RequestMapping(value = "/gateway/iit/report/getFeedback", method = RequestMethod.GET)
    ApiResponse<Feedback> getFeedback(@RequestParam("requestId") String requestId, @RequestParam("reportType") String reportType);

    /**
     * 申报作废
     *
     * @param request request
     * @return json字符串
     */
    @RequestMapping(value = "/gateway/iit/report/cancel", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> cancel(@JSONRequestBody DeclareCancelRequest request);

    /**
     * 申报作废反馈
     * @param requestId requestId
     * @return  json字符串
     */
    @RequestMapping(value = "/gateway/iit/report/getCancelFeedback", method = RequestMethod.GET)
    ApiResponse<Feedback> getCancelFeedback(@RequestParam("requestId") String requestId, @RequestParam("reportType") String reportType);

    /**
     * 申报数据接收
     *
     * @param request request
     * @return json字符串
     */
    @RequestMapping(value = "/gateway/iit/report/importData", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> importData(@JSONRequestBody CompanyDeclareRequest request);

    /**
     * 采集工具企业申报数据导入
     *
     * @param request request
     * @return json字符串
     */
    @RequestMapping(value = "/gateway/iit/report/importDataByAcquisitionTool", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> importDataByAcquisitionTool(@JSONRequestBody CompanyDeclareRequest request);

    /**
     * 申报数据接收反馈
     *
     * @param requestId requestId
     * @return json字符串
     */
    @RequestMapping(value = "/gateway/iit/report/getDataImportFeedback", method = RequestMethod.GET)
    ApiResponse<DataImportFeedback> getDataImportFeedback(@RequestParam("requestId") String requestId, @RequestParam("reportType") String reportType);

    /**
     * 企业申报数据明细查询 (查询已上传的申报明细数据)
     *
     * @param request request
     * @return json字符串
     */
    @RequestMapping(value = "/gateway/iit/report/getCompanyIncomes", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse getCompanyIncomes(@JSONRequestBody CompanyIncomeQueryRequest request);

    /**
     * 更正申报
     *
     * @param request request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/report/correct", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse correct(@JSONRequestBody DeclareCorrectRequest request);

    /**
     * 申报更正撤销
     *
     * @param request request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/report/cancelCorrect", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse cancelCorrect(@JSONRequestBody DeclareCorrectRequest request);

    /**
     * 查询局端申报状态
     *
     * @param baseRequest baseRequest
     * @return
     */
    @RequestMapping(value = "/gateway/iit/report/queryDeclarationRecord", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<QueryDeclarationRecordDTO> queryDeclarationRecord(@JSONRequestBody BaseRequest baseRequest);

    /**
     * 人员申报验证状态更新接口
     *
     * @param request request
     * @return 更新结果
     */
    @RequestMapping(value = "/gateway/iit/declare/downloadAuthenticationState", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<List<DownloadAuthenticationStateResultVO>> downloadAuthenticationState(@JSONRequestBody DownloadAuthenticationStateRequest request);

    /**
     * 查询申报内置算税结果
     *
     * @param requestId requestId
     * @return
     */
    @RequestMapping(value = "/gateway/iit/report/getDeclareTaxResultFeedback", method = RequestMethod.GET)
    ApiResponse<CalculateTaxResultRequest> getDeclareTaxResultFeedback(@RequestParam("requestId") String requestId);
}
