package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.declare.ListedFilingRecordQueryRequestVO;
import cn.com.servyou.dto.declare.ListedFilingRecordQueryResultVO;
import cn.com.servyou.dto.declare.deferredtax.DeferredTaxRequestVO;
import cn.com.servyou.dto.declare.deferredtax.DeferredTaxResultVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

import java.util.List;

/**
 * @author ranjh
 * @since 20210729
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface DeferredTaxRequest {

    /**
     * 递延纳税报送接口-发起
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/deferredTax/declare", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<AsyncResult> declare(@JSONRequestBody DeferredTaxRequestVO request);

    /**
     * 递延纳税报送接口-反馈
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/iit/deferredTax/feedback", method = RequestMethod.GET)
    ApiResponse<DeferredTaxResultVO> feedback(@RequestParam("requestId") String requestId);

    /**
     * 上市公司股权激励延期纳税备案信息查询发起
     *
     * @param request
     * @return 反馈结果
     */
    @RequestMapping(value = "/gateway/pts/wrt/declare/queryListedFilingRecordAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<AsyncResult> queryListedFilingRecordAsync(@JSONRequestBody ListedFilingRecordQueryRequestVO request);

    /**
     * 上市公司股权激励延期纳税备案信息查询反馈
     *
     * @param requestId requestId
     * @return json字符串
     */
    @RequestMapping(value = "/gateway/pts/wrt/declare/queryListedFilingRecordFeedback", method = RequestMethod.GET)
    ApiResponse<List<ListedFilingRecordQueryResultVO>> queryListedFilingRecordFeedback(@RequestParam("requestId") String requestId);

}
