package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.BaseRequest;
import cn.com.servyou.dto.dispute.DisputeMessageFeedback;
import cn.com.servyou.dto.dispute.DisputeMessageSubmitRequest;
import cn.com.servyou.dto.dispute.DissentAppealInviteConfirmationRequest;
import cn.com.servyou.dto.dispute.DissentAppealInviteConfirmationResult;
import cn.com.servyou.dto.dispute.QueryDissentAppealResult;
import cn.com.servyou.dto.dispute.SubmitDissentAppealRiskRequestVO;
import cn.com.servyou.dto.dispute.SubmitFeedbackResult;
import cn.com.servyou.dto.dispute.SubmitOnlineInquiryRequestVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

/**
 * 申诉
 *
 * @author zhouww
 * @since 20190829
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface DisputeRequest {

    /**
     * 申诉
     *
     * @param request request
     * @return json字符串
     */
    @RequestMapping(value = "/gateway/iit/dispute/query", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> query(@JSONRequestBody BaseRequest request);

    /**
     * 申诉反馈
     *
     * @param requestId requestId
     * @return  json字符串
     */
    @RequestMapping(value = "/gateway/iit/dispute/getFeedback", method = RequestMethod.GET)
    ApiResponse<DisputeMessageFeedback> getFeedback(@RequestParam("requestId") String requestId);

    /**
     * 申诉回复
     *
     * @param request request
     * @return json字符串
     */
    @RequestMapping(value = "/gateway/iit/dispute/submit", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<SubmitFeedbackResult> submit(@JSONRequestBody DisputeMessageSubmitRequest request);

    /**
     * 查询异议申诉属实记录人员
     *
     * @param request request
     * @return json字符串
     */
    @RequestMapping(value = "/gateway/iit/dispute/queryDissentAppeal", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<QueryDissentAppealResult> queryDissentAppeal(@JSONRequestBody BaseRequest request);

    /**
     * 发送扣缴确认申报申请
     * 单次请求最大人数限制为50人，只有状态为0未发送3不同意 可发送
     *
     * @param request request
     * @return json字符串
     */
    @RequestMapping(value = "/gateway/iit/dispute/inviteConfirmation", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<DissentAppealInviteConfirmationResult> inviteConfirmation(@JSONRequestBody DissentAppealInviteConfirmationRequest request);


    /**
     * 提交线上询证回复
     *
     * @param requestVO requestVO
     * @return 反馈结果
     */
    @RequestMapping(value = "/gateway/iit/dispute/submitOnlineInquiry", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<SubmitFeedbackResult> submitOnlineInquiry(@JSONRequestBody SubmitOnlineInquiryRequestVO requestVO);

    /**
     * 提交风险回复
     *
     * @param requestVO requestVO
     * @return 反馈结果
     */
    @RequestMapping(value = "/gateway/iit/dispute/submitDissentAppealRisk", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<SubmitFeedbackResult> submitDissentAppealRisk(@JSONRequestBody SubmitDissentAppealRiskRequestVO requestVO);
}
