package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.dispute.SubmitEITVerificationFeedbackRequestVO;
import cn.com.servyou.dto.dispute.SubmitEITVerificationOnlineInquiryFeedbackRequestVO;
import cn.com.servyou.dto.dispute.SubmitFeedbackResult;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;

/**
 * @author ranjh
 * @since 20220623
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface EITVerificationMessageRequest {

    /**
     * 企业所得税核查提醒反馈
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/verification/submitFeedback", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<SubmitFeedbackResult> submitEITVerificationFeedback(@JSONRequestBody SubmitEITVerificationFeedbackRequestVO request);

    /**
     * 企业所得税核查证明材料上传
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/verification/submitOnlineInquiryFeedback", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<SubmitFeedbackResult> submitEITVerificationOnlineInquiryFeedback(@JSONRequestBody SubmitEITVerificationOnlineInquiryFeedbackRequestVO request);

}
