package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.employee.EmployeeInformationChangeRequestVO;
import cn.com.servyou.dto.employee.EmployeeInformationChangeResultVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @author ranjh
 * @since 20210729
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
public interface EmployeeInformationChangeRequest {

    /**
     * 关键信息变更查询接口
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/employee/informationChange", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<EmployeeInformationChangeResultVO> query(@RequestBody EmployeeInformationChangeRequestVO request);
}
