package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.employee.BankAccountVerifyRequest;
import cn.com.servyou.dto.employee.BankAccountVerifyResultVO;
import cn.com.servyou.dto.employee.BatchInvalidSubmissionRequest;
import cn.com.servyou.dto.employee.BatchInvalidSubmissionResultVO;
import cn.com.servyou.dto.employee.DeclareEssentialInfoRequest;
import cn.com.servyou.dto.employee.EmployeeQueryRequest;
import cn.com.servyou.dto.employee.EssentialInfoFeedback;
import cn.com.servyou.dto.tax.CompanyEmployee;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

import java.util.List;

/**
 * 人员
 *
 * @author zhouww
 * @since 20191024
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface EmployeeRequest {

    /**
     * 人员信息登记报送
     *
     * @param request request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/declare/declareEmployeeInfo", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> declareEmployeeInfo(@JSONRequestBody DeclareEssentialInfoRequest request);

    /**
     * 人员数据接受反馈
     * @param requestId requestId
     * @return
     */
    @RequestMapping(value = "/gateway/iit/declare/getEmployeeInfoFeedback", method = RequestMethod.GET)
    ApiResponse<EssentialInfoFeedback> getEmployeeInfoFeedback(@RequestParam("requestId") String requestId);

    /**
     * 人员专项扣除信息登记报送
     *
     * @param request request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/declare/declareEssentialInfo", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> declareEssentialInfo(@JSONRequestBody DeclareEssentialInfoRequest request);

    /**
     * 人员专项扣除信息登记报送反馈
     * @param requestId requestId
     * @return
     */
    @RequestMapping(value = "/gateway/iit/declare/getEssentialInfoFeedback", method = RequestMethod.GET)
    ApiResponse<EssentialInfoFeedback> getEssentialInfoFeedback(@RequestParam("requestId") String requestId);

    /**
     * 作废人员信息
     *
     * @return
     */
    @RequestMapping(value = "/gateway/iit/declare/batchInvalidSubmission", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<List<BatchInvalidSubmissionResultVO>> batchInvalidSubmission(@JSONRequestBody BatchInvalidSubmissionRequest request);

    /**
     * 银行卡校验
     * 银行卡校验合并到人员报送接口中，这个接口已经作废
     *
     * @return
     */
    @Deprecated
    @RequestMapping(value = "/gateway/iit/verify/verifyBankAccount", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> verifyBankAccount(@JSONRequestBody BankAccountVerifyRequest request);

    /**
     * 银行卡校验反馈
     *
     * @return
     */
    @Deprecated
    @RequestMapping(value = "/gateway/iit/verify/getVerifyBankAccountFeedback", method = RequestMethod.GET)
    ApiResponse<BankAccountVerifyResultVO> getVerifyBankAccountFeedback(@RequestParam("requestId") String requestId);

    /**
     * 查询企业人员列表
     *
     * @return
     */
    @RequestMapping(value = "/gateway/iit/data/getCompanyEmployee", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<List<CompanyEmployee>> getCompanyEmployee(@JSONRequestBody EmployeeQueryRequest request);
}
