package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.BaseRequest;
import cn.com.servyou.dto.declare.DeclareEquityIncentiveCancelRequest;
import cn.com.servyou.dto.declare.DeclareEquityIncentiveCancelResultVO;
import cn.com.servyou.dto.declare.DeclareEquityIncentiveRequest;
import cn.com.servyou.dto.declare.DeclareEquityIncentiveResultVO;
import cn.com.servyou.dto.declare.EquityIncentiveConditionReportResultVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

/**
 * 股权激励报送相关接口
 *
 * @author yjiah
 * @since 20220117
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface EquityIncentiveRequest {

    /**
     * 股权激励报送接口
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/equityIncentive/declare", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<AsyncResult> declareEquityIncentive(@JSONRequestBody DeclareEquityIncentiveRequest request);

    /**
     * 股权激励报送反馈
     *
     * @param requestId requestId
     * @return json字符串
     */
    @RequestMapping(value = "/gateway/iit/equityIncentive/declareFeedback", method = RequestMethod.GET)
    ApiResponse<DeclareEquityIncentiveResultVO> declareEquityIncentiveFeedback(@RequestParam("requestId") String requestId);

    /**
     * 股权激励作废接口
     *
     * @param request
     * @return 申报反馈结果
     */
    @RequestMapping(value = "/gateway/iit/equityIncentive/cancel", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<DeclareEquityIncentiveCancelResultVO> declareEquityIncentiveCancel(@JSONRequestBody DeclareEquityIncentiveCancelRequest request);

    /**
     * 股权激励情况报告表查询接口
     *
     * @param request
     * @return 反馈结果
     */
    @RequestMapping(value = "/gateway/pts/wrt/declare/queryEquityIncentive", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<EquityIncentiveConditionReportResultVO> queryEquityIncentive(@JSONRequestBody BaseRequest request);
}
