package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.dispute.EquitytTransferMessageFeedbackRequestVO;
import cn.com.servyou.dto.dispute.EquitytTransferMessageFeedbackResultVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;

/**
 * @author ranjh
 * @since 20210729
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface EquitytTransferMessageRequest {

    /**
     * 股权转让信息核对反馈
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/equitytTransfer/inviteConfirmation", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<EquitytTransferMessageFeedbackResultVO> query(@JSONRequestBody EquitytTransferMessageFeedbackRequestVO request);
}
