package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.file.FileUploadResultVO;
import cn.com.servyou.dto.file.FileUploadVO;
import cn.com.servyou.dto.file.FileVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

/**
 * 文件查询
 *
 * @author zhouww
 * @since 20210422
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface FileRequest {

    /**
     * 文件查询
     *
     * @param requestId requestId
     * @param fileId    fileId
     * @return 文件信息
     */
    @RequestMapping(value = "/gateway/iit/file/query", method = RequestMethod.GET)
    ApiResponse<FileVO> queryFile(@RequestParam("requestId") String requestId, @RequestParam("fileId") String fileId);


    /**
     * 文件上传
     *
     * @param fileUploadVO fileUploadVO
     * @return 文件信息
     */
    @RequestMapping(value = "/gateway/file/upload", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<FileUploadResultVO> fileUploadFile(@JSONRequestBody FileUploadVO fileUploadVO);

}
