package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.merged.EmployeeArchiveMergeResult;
import cn.com.servyou.dto.merged.EmployeeMergeRequest;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

import java.util.List;

/**
 * 人员并挡
 *
 * @author zhouww
 * @since 20190829
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface MergedArchivesRequest {

    /**
     * 人员并挡
     *
     * @param request request
     * @return json字符串
     */
    @RequestMapping(value = "/gateway/iit/mergedEmployeeArchives/query", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> query(@JSONRequestBody EmployeeMergeRequest request);

    /**
     * 并挡反馈
     *
     * @param requestId requestId
     * @return  json字符串
     */
    @RequestMapping(value = "/gateway/iit/mergedEmployeeArchives/getFeedback", method = RequestMethod.GET)
    ApiResponse<List<EmployeeArchiveMergeResult>> getFeedback(@RequestParam("requestId") String requestId);

}
