package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.dispute.DisputeMessageQueryRequest;
import cn.com.servyou.dto.dispute.DownloadMessageResultVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

/**
 * @author ranjh
 * @since 20210729
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface MessageRequest {

    /**
     * 消息查询
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/message/query", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<AsyncResult> query(@JSONRequestBody DisputeMessageQueryRequest request);

    /**
     * 消息反馈
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/iit/message/getFeedback", method = RequestMethod.GET)
    ApiResponse<DownloadMessageResultVO> getFeedback(@RequestParam("requestId") String requestId);

}
