package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.BaseRequest;
import cn.com.servyou.dto.declare.DeclareTypeRequest;
import cn.com.servyou.dto.payment.AgreementFeedback;
import cn.com.servyou.dto.payment.ArrearageFeedback;
import cn.com.servyou.dto.payment.ArrearageResultV2VO;
import cn.com.servyou.dto.payment.CancelTaxReceiptNumberRequestVO;
import cn.com.servyou.dto.payment.CancelTaxReceiptNumberResultVO;
import cn.com.servyou.dto.payment.SyncWithholdingRequest;
import cn.com.servyou.dto.payment.ThirdPartyWithholdingCancelResultVO;
import cn.com.servyou.dto.payment.ThirdPartyWithholdingFeedbackVO;
import cn.com.servyou.dto.payment.ThirdPartyWithholdingRequestVO;
import cn.com.servyou.dto.payment.UnionPayResult;
import cn.com.servyou.dto.payment.WithheldVoucherResult;
import cn.com.servyou.dto.payment.WithholdingFeedback;
import cn.com.servyou.dto.payment.WithholdingRequest;
import cn.com.servyou.dto.payment.WithholdingResult;
import cn.com.servyou.dto.payment.WithholdingVoucherFeedback;
import cn.com.servyou.dto.payment.WithholdingVoucherPaymentResult;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 缴款服务
 *
 * @author zhouww
 * @since 20190829
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface PaymentRequest {

    /**
     * 查询三方协议
     *
     * @param request request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/payment/queryAgreement", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> queryAgreement(@JSONRequestBody BaseRequest request);

    /**
     * 查询三方协议反馈
     *
     * @param requestId requestId
     * @return
     */
    @RequestMapping(value = "/gateway/iit/payment/getAgreementQueryFeedback", method = RequestMethod.GET)
    ApiResponse<AgreementFeedback> getAgreementQueryFeedback(@RequestParam("requestId") String requestId);

    /**
     * 欠费查询
     *
     * @param request request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/payment/queryArrearage", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> queryArrearage(@JSONRequestBody BaseRequest request);

    /**
     * 欠费查询反馈
     * @param requestId requestId
     * @return
     */
    @RequestMapping(value = "/gateway/iit/payment/getArrearageQueryFeedback", method = RequestMethod.GET)
    ApiResponse<ArrearageFeedback>  getArrearageQueryFeedback(@RequestParam("requestId") String requestId);

    /**
     * 缴款发起
     *
     * @param request request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/payment/declareWithholding", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> declareWithholding(@JSONRequestBody WithholdingRequest request);

    /**
     * 获取缴款发起反馈
     * @param requestId requestId
     * @return
     */
    @RequestMapping(value = "/gateway/iit/payment/getWithholdingFeedback", method = RequestMethod.GET)
    ApiResponse<WithholdingFeedback> getWithholdingFeedback(@RequestParam("requestId") String requestId);

    /**
     * 打印缴款凭证
     * @param request request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/payment/withholdingVoucher", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> getWithholdingVoucher(@JSONRequestBody BaseRequest request);

    /**
     * 缴款凭证反馈
     * @param requestId requestId
     * @return
     */
    @RequestMapping(value = "/gateway/iit/payment/getWithholdingVoucherFeedback", method = RequestMethod.GET)
    ApiResponse<WithholdingVoucherFeedback> getWithholdingVoucherFeedback(@RequestParam("requestId") String requestId);

    /**
     * 作废缴款凭证
     *
     * @param declareTypeRequest declareTypeRequest
     * @return
     */
    @RequestMapping(value = "/gateway/iit/payment/cancelWithholdingVoucher", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse cancelWithholdingVoucher(@JSONRequestBody DeclareTypeRequest declareTypeRequest);

    /**
     * 查询缴款凭证的缴款结果
     *
     * @param request request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/payment/getWithholdingVouchersPaymentResult", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<WithholdingVoucherPaymentResult> getWithholdingVouchersPaymentResult(@JSONRequestBody BaseRequest request);

    /**
     * 完税证明
     *
     * @param request request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/payment/getWithheldVoucher", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<WithheldVoucherResult> getWithheldVoucher(@JSONRequestBody BaseRequest request);

    /**
     * 银联缴款
     * 银联缴款需先查询欠费接口，获取欠费信息
     *
     * @param request request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/payment/getUnionPayUrl", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<UnionPayResult> getUnionPayUrl(@JSONRequestBody SyncWithholdingRequest request);

    /**
     * 缴款反馈
     *
     * @param request request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/payment/getSyncWithholdingFeedback", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<WithholdingResult> getSyncWithholdingFeedback(@JSONRequestBody SyncWithholdingRequest request);

    /**
     * 收银台缴款
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/payment/thirdPartyWithholding", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<List<ThirdPartyWithholdingFeedbackVO>> getThirdPartyWithholding(@RequestBody ThirdPartyWithholdingRequestVO request);

    /**
     * 收银台欠费查询
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/payment/queryThirdPartyArrearage", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<ArrearageResultV2VO> queryThirdPartyArrearage(@RequestBody BaseRequest request);

    /**
     * 收银台缴款作废
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/payment/thirdPartyWithholdingCancel", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<List<ThirdPartyWithholdingCancelResultVO>> thirdPartyWithholdingCancel(@RequestBody BaseRequest request);

    /**
     * 作废电子税票号码
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/taxReceiptNumber/cancel", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<CancelTaxReceiptNumberResultVO> cancelTaxReceiptNumber(@RequestBody CancelTaxReceiptNumberRequestVO request);
}
