package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.declare.PersonalDeclarationDetailResultVO;
import cn.com.servyou.dto.declare.PersonalDeclarationQueryRequest;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;

/**
 * @author ranjh
 * @since 20220310
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface PersonalDeclarationRequest {

    /**
     * 个人的申报情况查询
     *
     * @param personalDeclarationQueryRequest
     * @return
     */
    @RequestMapping(value = "/gateway/iit/personalDeclaration/queryPersonalDeclarationDetail", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<PersonalDeclarationDetailResultVO> queryPersonalDeclarationDetail(@JSONRequestBody PersonalDeclarationQueryRequest personalDeclarationQueryRequest);

}
