package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.declare.PersonalPensionCollectionRequestVO;
import cn.com.servyou.dto.declare.PersonalPensionCollectionResultVO;
import cn.com.servyou.dto.declare.PersonalPensionRequestVO;
import cn.com.servyou.dto.declare.PersonalPensionResultVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

import java.util.List;

/**
 * 个人养老金
 *
 * @author ranjh
 * @since 20210729
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface PersonalPensionRequest {

    /**
     * 下载个人养老金
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/personalPension/download", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<AsyncResult> downloadPersonalPension(@JSONRequestBody PersonalPensionRequestVO request);

    /**
     * 获取个人养老金下载反馈
     *
     * @param requestId requestId
     * @return
     */
    @RequestMapping(value = "/gateway/iit/personalPension/getDownloadFeedback", method = RequestMethod.GET)
    ApiResponse<List<PersonalPensionResultVO>> getDownloadFeedback(@RequestParam("requestId") String requestId);

    /**
     * 采集个人养老金
     *
     * @param personalPensionCollectionRequestVO
     * @return
     */
    @RequestMapping(value = "/gateway/iit/personalPension/collection", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<AsyncResult> collectionPersonalPension(@JSONRequestBody PersonalPensionCollectionRequestVO personalPensionCollectionRequestVO);

    /**
     * 获取采集个人养老金反馈
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/iit/personalPension/getCollectionFeedback", method = RequestMethod.GET)
    ApiResponse<List<PersonalPensionCollectionResultVO>> getCollectionFeedbac(@RequestParam("requestId") String requestId);
}
