package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.tax.PreDeductDeductionAmountConfirmRequest;
import cn.com.servyou.dto.tax.PreDeductDeductionAmountConfirmResult;
import cn.com.servyou.dto.tax.PreDeductDeductionAmountQueryRequest;
import cn.com.servyou.dto.tax.PreDeductDeductionAmountQueryResult;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

/**
 * 年收入不足6万元的纳税人暂不预扣预缴税款
 *
 * @author zhouww
 * @since 20201224
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface PreDeductDeductionAmountRequest {

    /**
     * 扣除名单查询
     *
     * @param request 请求参数
     * @return
     */
    @RequestMapping(value = "/gateway/iit/deductionAmount/queryPreDeduct", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<PreDeductDeductionAmountQueryResult> queryPreDeduct(@JSONRequestBody PreDeductDeductionAmountQueryRequest request);

    /**
     * 确认扣除结果
     *
     * @param request request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/deductionAmount/confirmPreDeduct", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> confirmPreDeduct(@JSONRequestBody PreDeductDeductionAmountConfirmRequest request);

    /**
     * 确认扣除结果反馈
     *
     * @param requestId requestId
     * @return
     */
    @RequestMapping(value = "/gateway/iit/deductionAmount/getPreDeductConfirmFeedback", method = RequestMethod.GET)
    ApiResponse<PreDeductDeductionAmountConfirmResult> getPreDeductConfirmFeedback(@RequestParam("requestId") String requestId);
}
