package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.salarydata.SalaryDataCalculateRequestVO;
import cn.com.servyou.dto.salarydata.SalaryDataImportRequestVO;
import cn.com.servyou.dto.salarydata.SalaryDataImportResultVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

/**
 * @author ranjh
 * @since 20240509
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface SalaryImportRequest {

    /**
     * 薪酬数据导入接口-发起
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/salaryData/import", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<AsyncResult> importSalaryData(@JSONRequestBody SalaryDataImportRequestVO request);

    /**
     * 薪酬数据导入接口-反馈
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/iit/salaryData/getImportFeedback", method = RequestMethod.GET)
    ApiResponse<SalaryDataImportResultVO> getImportFeedback(@RequestParam("requestId") String requestId);

    /**
     * 触发平台算税
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/salaryData/calculateTax", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<AsyncResult> calculateTax(@JSONRequestBody SalaryDataCalculateRequestVO request);

}
