package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;

/**
 * @author wulg
 * @since 20240627
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface SecurityAuthUrlRequest {

    /**
     * 生成安全认证地址
     *
     * @param requestJson
     * @return
     */
    @RequestMapping(value = "/gateway/ets/securityAuthUrl/generate", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<String> generate(@JSONRequestBody String requestJson);

}
