package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.tax.deduction.EmployeeSpecialDeduction;
import cn.com.servyou.dto.tax.deduction.SpecialDeductionQueryRequestVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;

import java.util.List;

/**
 * @author ranjh
 * @since 20210729
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface SpecialDeductionQueryRequest {

    /**
     * 获取企业下所有人员的专项
     *
     * @return
     */
    @RequestMapping(value = "/gateway/iit/data/getSpecialDeduction", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<List<EmployeeSpecialDeduction>> getSpecialDeduction(@JSONRequestBody SpecialDeductionQueryRequestVO baseRequest);
}
