package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.BaseRequest;
import cn.com.servyou.dto.tax.deduction.SpecialQueryRequest;
import cn.com.servyou.dto.tax.deduction.SpecialQueryResultVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

/**
 * @author ranjh
 * @since 20210923
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface SpecialRequest {

    /**
     * 专项查询
     *
     * @param specialQueryRequest
     * @return
     */
    @RequestMapping(value = "/gateway/iit/special/querySpecialAmount", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> querySpecialAmount(@JSONRequestBody SpecialQueryRequest specialQueryRequest);

    /**
     * 专项附加扣除金额查询反馈接口
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/iit/special/getQuerySpecialAmountFeedback", method = RequestMethod.GET)
    ApiResponse<SpecialQueryResultVO> getQuerySpecialAmountFeedback(@RequestParam("requestId") String requestId);

    /**
     * 专项下载
     *
     * @return
     */
    @RequestMapping(value = "/gateway/iit/special/download", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<AsyncResult> downloadSpecial(@JSONRequestBody BaseRequest baseRequest);

    /**
     * 专项下载
     *
     * @return
     */
    @RequestMapping(value = "/gateway/iit/special/feedback", method = RequestMethod.GET)
    ApiResponse downloadSpecialFeedback(@RequestParam("requestId") String requestId);
}
