package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.statistic.CompanyUsageStatisticRequestVO;
import cn.com.servyou.dto.statistic.CompanyUsageStatisticResultVO;
import cn.com.servyou.dto.statistic.CustomerDailyBillDetailResultVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;

import java.util.List;

/**
 * @author ranjh
 * @since 20210729
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface StatisticRequest {

    /**
     * 获取流量统计-月账单
     *
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "/gateway/iit/statistic/queryUsageSummaryStatistic", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<CompanyUsageStatisticResultVO> queryUsageStatistic(@JSONRequestBody CompanyUsageStatisticRequestVO requestVO);

    /**
     * 获取流量统计-日账单
     *
     * @param requestVO
     * @return
     */
    @RequestMapping(value = "/gateway/iit/statistic/queryUsageDetailStatistic", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<List<CustomerDailyBillDetailResultVO>> queryUsageDetailStatistic(@JSONRequestBody CompanyUsageStatisticRequestVO requestVO);
}
