package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.declare.TaxPaymentQueryRequestVO;
import cn.com.servyou.dto.declare.TaxPaymentQueryResultVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;

import java.util.List;

/**
 * @author ranjh
 * @since 20220310
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface TaxPaymentRecordRequest {

    /**
     * 缴税记录查询
     *
     * @param taxPaymentQueryRequestVO
     * @return
     */
    @RequestMapping(value = "/gateway/iit/taxPayment/queryTaxPayment", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<List<TaxPaymentQueryResultVO>> queryTaxPayment(@JSONRequestBody TaxPaymentQueryRequestVO taxPaymentQueryRequestVO);

}
