package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.tax.CalculateFeedbackWithoutRequestIdRequest;
import cn.com.servyou.dto.tax.CalculateIndividualIncomeTaxRequest;
import cn.com.servyou.dto.tax.CalculateTaxResultRequest;
import cn.com.servyou.dto.tax.CalculateTaxWithoutRequestIdResult;
import cn.com.servyou.dto.tax.ClearSalaryDataRequest;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

/**
 * 算税请求接口
 *
 * @author zhouww
 * @since 20191024
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface TaxRequest {

    /**
     * 异步算税
     *
     * @param request request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/calculateTax/calculateASynIndividualIncomeTax", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> calculateASynIndividualIncomeTax(@JSONRequestBody CalculateIndividualIncomeTaxRequest request);

    /**
     * 查询算税反馈
     * @param requestId requestId
     * @return
     */
    @RequestMapping(value = "/gateway/iit/calculateTax/getASynIndividualIncomeTaxFeedback", method = RequestMethod.GET)
    ApiResponse<CalculateTaxResultRequest> getASynIndividualIncomeTaxFeedback(@RequestParam("requestId") String requestId);

    /**
     * 同步算税
     *
     * @param request request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/calculateTax/calculateSynIndividualIncomeTax", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<CalculateTaxResultRequest> calculateSynIndividualIncomeTax(@JSONRequestBody CalculateIndividualIncomeTaxRequest request);

    /**
     * 一月多次算税清空数据
     *
     * @param request request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/calculateTax/batchClearSalaryData", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse batchClearSalaryData(@JSONRequestBody ClearSalaryDataRequest request);

    /**
     * 合并算税
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/calculateTax/mergeAndCalculateAsyncIndividualIncomeTax", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> mergeAndCalculateAsyncIndividualIncomeTax(@JSONRequestBody CalculateIndividualIncomeTaxRequest request);

    /**
     * 反算 综合-正常工资薪金
     *
     * @param request request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/reverseCalculateTax/calculateASynIndividualIncomeTax", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> reverseCalculateASynIndividualIncomeTax(@JSONRequestBody CalculateIndividualIncomeTaxRequest request);

    /**
     * 查询反算反馈结果
     *
     * @param requestId requestId
     * @return
     */
    @RequestMapping(value = "/gateway/iit/reverseCalculateTax/getASynIndividualIncomeTaxFeedback", method = RequestMethod.GET)
    ApiResponse<CalculateTaxResultRequest> getReverseASynIndividualIncomeTaxFeedback(@RequestParam("requestId") String requestId);

    /**
     * 不用requestId获取算税反馈
     * 场景：平台算税
     *
     * @param request request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/calculateTax/getTaxFeedbackWithoutRequestId", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<CalculateTaxWithoutRequestIdResult> getTaxFeedbackWithoutRequestId(@JSONRequestBody CalculateFeedbackWithoutRequestIdRequest request);

}
