package cn.com.servyou.service;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.common.MultiCustomerTransferBaseRequest;
import cn.com.servyou.dto.transfer.TransferRequestVO;
import cn.com.servyou.dto.transfer.TransferResultDetailVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

import java.util.List;

/**
 * its数据迁移
 *
 * @author ranjh
 * @since 20240524
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface TransferRequest {

    /**
     * 迁移数据
     *
     * @param request request
     * @return
     */
    @RequestMapping(value = "/gateway/iit/transfer/transferData", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<AsyncResult> transferData(@JSONRequestBody MultiCustomerTransferBaseRequest<TransferRequestVO> request);

    /**
     * 迁移数据反馈
     *
     * @param requestId requestId
     * @return
     */
    @RequestMapping(value = "/gateway/iit/transfer/getTransferDataFeedback", method = RequestMethod.GET)
    ApiResponse<List<TransferResultDetailVO>> getParseDBDataFeedback(@RequestParam("requestId") String requestId);
}
