package cn.com.servyou.service.invoice;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.invoice.InvoiceApplyInfoResultVO;
import cn.com.servyou.dto.invoice.InvoiceComplementRequestVO;
import cn.com.servyou.dto.invoice.InvoiceComplementResultVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

/**
 * @author sunjl
 * @since 20220922
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface InvoiceComplementRequest {

    /**
     * 进项发票补全
     *
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/inInvoiceComplement", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<InvoiceApplyInfoResultVO> inInvoiceComplement(@JSONRequestBody InvoiceComplementRequestVO invoiceComplementRequestVO);

    /**
     * 获取进项发票补全反馈
     */
    @RequestMapping(value = "/gateway/ets/invoice/getInInvoiceComplementFeedback", method = RequestMethod.GET)
    ApiResponse<InvoiceComplementResultVO> getInInvoiceComplementFeedback(@RequestParam(value = "requestId") String requestId);

}
