package cn.com.servyou.service.invoice;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.invoice.InvoiceApplyInfoResultVO;
import cn.com.servyou.dto.invoice.InvoiceBaseRequestVO;
import cn.com.servyou.dto.invoice.InvoiceInputRequestVO;
import cn.com.servyou.dto.invoice.InvoicePlatformApplyRequestVO;
import cn.com.servyou.dto.invoice.InvoicePlatformApplyResultVO;
import cn.com.servyou.dto.invoice.InvoiceQueryApplyStatusRequestVO;
import cn.com.servyou.dto.invoice.InvoiceQueryApplyStatusResultVO;
import cn.com.servyou.dto.invoice.QueryApplyInvoiceInfoResultVO;
import cn.com.servyou.dto.invoice.QueryInvoiceStockRequestVO;
import cn.com.servyou.dto.invoice.QueryInvoiceStockResultVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;

import java.util.List;

/**
 * 发票平台-申领相关
 *
 * @author rjq
 * @since 20220526
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface InvoicePlatformApplyRequest {
    /**
     * 申领准备信息查询
     *
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/getInvoiceApplyInfo", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<InvoiceApplyInfoResultVO> getInvoiceApplyInfo(@JSONRequestBody InvoiceBaseRequestVO invoiceBaseRequestVO);

    /**
     * 发票申领
     *
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/invoiceApply", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<InvoicePlatformApplyResultVO> invoiceApply(@JSONRequestBody InvoicePlatformApplyRequestVO invoicePlatformApplyRequestVO);

    /**
     * 发票申领状态查询
     *
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/getInvoiceApplyStatus", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<InvoiceQueryApplyStatusResultVO> getInvoiceApplyStatus(@JSONRequestBody InvoiceQueryApplyStatusRequestVO invoiceQueryApplyStatusRequestVO);

    /**
     * 发票网上购票录入
     *
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/purchaseInvoiceEntry", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse purchaseInvoiceEntry(@JSONRequestBody InvoiceInputRequestVO invoiceInputRequestVO);

    /**
     * 发票网上购票信息查询
     *
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/getPurchaseInvoiceInfo", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    public ApiResponse<QueryApplyInvoiceInfoResultVO> getPurchaseInvoiceInfo(@JSONRequestBody InvoiceInputRequestVO invoiceInputRequestVO);

    /**
     * 发票库存查询
     *
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/getInvoiceStock", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    public ApiResponse<List<QueryInvoiceStockResultVO>> getInvoiceStock(@JSONRequestBody QueryInvoiceStockRequestVO queryInvoiceStockRequestVO);

}
