package cn.com.servyou.service.invoice;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.invoice.GetInvoiceBillingApplyResultRequestVO;
import cn.com.servyou.dto.invoice.GetInvoiceBillingApplyResultVO;
import cn.com.servyou.dto.invoice.GetSyncHistoryInvoiceResultVO;
import cn.com.servyou.dto.invoice.InvalidInvoiceRequestVO;
import cn.com.servyou.dto.invoice.InvalidInvoiceResultVO;
import cn.com.servyou.dto.invoice.InvoiceBillingApplyRequestVO;
import cn.com.servyou.dto.invoice.InvoiceBillingApplyResultVO;
import cn.com.servyou.dto.invoice.QueryInvoicePageRequestVO;
import cn.com.servyou.dto.invoice.QueryInvoicePageResultVO;
import cn.com.servyou.dto.invoice.RedInvoiceApplyCancelRequestVO;
import cn.com.servyou.dto.invoice.RedInvoiceApplyCancelResultVO;
import cn.com.servyou.dto.invoice.RedInvoiceApplyQueryRequestVO;
import cn.com.servyou.dto.invoice.RedInvoiceApplyQueryResultVO;
import cn.com.servyou.dto.invoice.RedInvoiceApplySubmitRequestVO;
import cn.com.servyou.dto.invoice.RedInvoiceApplySubmitResultVO;
import cn.com.servyou.dto.invoice.StatisticsInvoiceAndTaxRateRequest;
import cn.com.servyou.dto.invoice.StatisticsInvoiceAndTaxRateResultVO;
import cn.com.servyou.dto.invoice.SyncHistoryInvoiceRequestVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

/**
 * 发票平台-开票和发票管理相关
 *
 * @author rjq
 * @version 2220526
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface InvoicePlatformBillingRequest {
    /**
     * 开票申请
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/invoiceBillingApply", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<InvoiceBillingApplyResultVO> invoiceBillingApply(@JSONRequestBody InvoiceBillingApplyRequestVO invoiceBillingApplyRequestVO);

    /**
     * 开票结果查询
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/getInvoiceBillingResult", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<GetInvoiceBillingApplyResultVO> getInvoiceBillingResult(@JSONRequestBody GetInvoiceBillingApplyResultRequestVO getInvoiceBillingApplyResultRequestVO);

    /**
     * 红字信息表申请
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/redInvoiceApply", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<RedInvoiceApplySubmitResultVO> redInvoiceApply(@JSONRequestBody RedInvoiceApplySubmitRequestVO redInvoiceApplySubmitRequestVO);

    /**
     * 红字信息表查询
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/getRedInvoiceApplyResult", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<RedInvoiceApplyQueryResultVO> getRedInvoiceApplyResult(@JSONRequestBody RedInvoiceApplyQueryRequestVO redInvoiceApplyQueryRequestVO);

    /**
     * 红字信息表撤销
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/cancelRedInvoiceApply", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<RedInvoiceApplyCancelResultVO> cancelRedInvoiceApply(@JSONRequestBody RedInvoiceApplyCancelRequestVO redInvoiceApplyCancelRequestVO);

    /**
     * 发票作废
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/invalidInvoice", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<InvalidInvoiceResultVO> invalidInvoice(@JSONRequestBody InvalidInvoiceRequestVO invalidInvoiceRequestVO);

    /**
     * 同步历史发票
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/syncHistoryInvoice", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> syncHistoryInvoice(@JSONRequestBody SyncHistoryInvoiceRequestVO syncHistoryInvoiceRequestVO);

    /**
     * 获取同步历史发票反馈
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/getSyncHistoryInvoiceFeedback", method = RequestMethod.GET)
    ApiResponse<GetSyncHistoryInvoiceResultVO> getSyncHistoryInvoiceFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 分页查询发票
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/queryInvoicePageList", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<QueryInvoicePageResultVO> queryInvoicePageList(@JSONRequestBody QueryInvoicePageRequestVO queryInvoicePageRequestVO);

    /**
     * 查询发票汇总表
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/statisticsInvoiceAndTaxRate", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<StatisticsInvoiceAndTaxRateResultVO> statisticsInvoiceAndTaxRate(@JSONRequestBody StatisticsInvoiceAndTaxRateRequest request);

}
