package cn.com.servyou.service.invoice;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.invoice.ClearCardRequestVO;
import cn.com.servyou.dto.invoice.CopyTaxRequestVO;
import cn.com.servyou.dto.invoice.InvoiceBaseRequestVO;
import cn.com.servyou.dto.invoice.QueryMonitorRequestVO;
import cn.com.servyou.dto.invoice.QueryMonitorResultVO;
import cn.com.servyou.dto.invoice.QueryUploadStateResultVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;

/**
 * 发票平台-抄报清卡相关
 *
 * @author rjq
 * @since 20220526
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface InvoicePlatformCopyTaxRequest {

    /**
     * 上传状态查询
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/queryUploadState", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<QueryUploadStateResultVO> queryUploadState(@JSONRequestBody InvoiceBaseRequestVO invoiceBaseRequestVO);

    /**
     * 监控数据查询
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/getMonitorData", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<QueryMonitorResultVO> getMonitorData(@JSONRequestBody QueryMonitorRequestVO queryMonitorRequestVO);

    /**
     * 网上数据抄报
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/copyTax", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse copyTax(@JSONRequestBody CopyTaxRequestVO copyTaxRequestVO);

    /**
     * 反写监控管理数据
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/clearCard", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse clearCard(@JSONRequestBody ClearCardRequestVO clearCardRequestVO);
}
