package cn.com.servyou.service.invoice;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.invoice.BatchUpdateTaxPlatePasswordResultVO;
import cn.com.servyou.dto.invoice.InvoiceBatchCancelOpenServiceRequestVO;
import cn.com.servyou.dto.invoice.InvoiceBatchCancelOpenServiceResultVO;
import cn.com.servyou.dto.invoice.InvoiceBatchInitTaxPlateRequestVO;
import cn.com.servyou.dto.invoice.InvoiceBatchInitTaxPlateResultVO;
import cn.com.servyou.dto.invoice.InvoiceBatchOpenServiceRequestVO;
import cn.com.servyou.dto.invoice.InvoiceBatchOpenServiceResultVO;
import cn.com.servyou.dto.invoice.InvoiceBatchUpdateTaxPlatePasswordRequestVO;
import cn.com.servyou.dto.invoice.InvoiceRackRequestVO;
import cn.com.servyou.dto.invoice.QueryRackRequestVO;
import cn.com.servyou.dto.invoice.QueryRackResultVO;
import cn.com.servyou.dto.invoice.QueryTaxPlateRequestVO;
import cn.com.servyou.dto.invoice.QueryTaxPlateResultVO;
import cn.com.servyou.dto.invoice.ReplaceTaxPlateRequestVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

/**
 * 发票平台-机柜税盘设置相关
 *
 * @author sunjl
 * @since 20220428
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface InvoicePlatformSettingRequest {

    /**
     * 机柜信息查询
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/queryRackInfo", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<QueryRackResultVO> queryRackInfo(@JSONRequestBody QueryRackRequestVO queryRackRequestVO);

    /**
     * 绑定机柜
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/bindingRack", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse bindingRack(@JSONRequestBody InvoiceRackRequestVO invoiceRackRequestVO);

    /**
     * 解绑机柜
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/unbindingRack", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse unbindingRack(@JSONRequestBody InvoiceRackRequestVO invoiceRackRequestVO);

    /**
     * 查询税盘状态
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/queryTaxPlate", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<QueryTaxPlateResultVO> queryTaxPlate(@JSONRequestBody QueryTaxPlateRequestVO queryTaxPlateRequestVO);

    /**
     * 批量初始化
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/batchInitTaxPlate", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<InvoiceBatchInitTaxPlateResultVO> batchInitTaxPlate(@JSONRequestBody InvoiceBatchInitTaxPlateRequestVO batchInitTaxPlateRequestVO);

    /**
     * 批量服务开通
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/batchOpenService", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<InvoiceBatchOpenServiceResultVO> batchOpenService(@JSONRequestBody InvoiceBatchOpenServiceRequestVO batchOpenServiceRequestVO);

    /**
     * 批量服务开通取消
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/batchCancelOpenService", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<InvoiceBatchCancelOpenServiceResultVO> batchCancelOpenService(@JSONRequestBody InvoiceBatchCancelOpenServiceRequestVO batchCancelOpenServiceRequestVO);

    /**
     * 更换税盘
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/replaceTaxPlate", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse replaceTaxPlate(@JSONRequestBody ReplaceTaxPlateRequestVO replaceTaxPlateRequestVO);


    /**
     * 批量修改税盘密码接口
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/batchUpdateTaxPlatePassword", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> batchUpdateTaxPlatePassword(@JSONRequestBody InvoiceBatchUpdateTaxPlatePasswordRequestVO request);

    /**
     * 批量修改税盘密码接口反馈
     */
    @RequestMapping(value = "/gateway/ets/invoice/platform/getBatchUpdateTaxPlatePasswordFeedBack", method = RequestMethod.GET)
    ApiResponse<BatchUpdateTaxPlatePasswordResultVO> getBatchUpdateTaxPlatePasswordFeedBack(@RequestParam(value = "requestId") String requestId);
}

