package cn.com.servyou.service.invoice.digitization;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

/**
 * @author rjq
 * @since 20230323
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface BillingRequest {
    /**
     * 全电发票--批量蓝字开票
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/batchBlueBillingAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String batchBlueBillingAsync(@JSONRequestBody String request);

    /**
     * 全电发票--批量蓝字开票反馈
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/batchBlueBillingAsyncFeedback", method = RequestMethod.GET)
    String batchBlueBillingAsyncFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 全电发票--蓝字开票
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/blueBillingAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String blueBillingAsync(@JSONRequestBody String request);

    /**
     * 全电发票--蓝字开票反馈
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/blueBillingAsyncFeedback", method = RequestMethod.GET)
    String blueBillingAsyncFeedback(@RequestParam(value = "requestId") String requestId);
}
