package cn.com.servyou.service.invoice.digitization;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

/**
 * 发票勾选确认
 *
 * @author wulg
 * @since 20231026
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface InvoiceCheckRequest {

    /**
     * 全电发票--查询未勾选/已勾选发票
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/queryInputCheckOrUnCheckAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String queryInputCheckOrUnCheckAsync(@JSONRequestBody String request);

    /**
     * 全电发票--查询未勾选/已勾选发票反馈
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/queryInputCheckOrUnCheckAsyncFeedback", method = RequestMethod.GET)
    String queryInputCheckOrUnCheckAsyncFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 全电发票--抵扣勾选/撤销抵扣勾选
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/deductiveCheckAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String deductiveCheckAsync(@JSONRequestBody String request);

    /**
     * 全电发票--抵扣勾选/撤销抵扣勾选反馈
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/deductiveCheckAsyncFeedback", method = RequestMethod.GET)
    String deductiveCheckAsyncFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 全电发票--查询勾选统计信息
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/queryCheckStatisticInfoAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String queryCheckStatisticInfoAsync(@JSONRequestBody String request);

    /**
     * 全电发票--查询勾选统计信息反馈
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/queryCheckStatisticInfoAsyncFeedback", method = RequestMethod.GET)
    String queryCheckStatisticInfoAsyncFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 全电发票--申请勾选统计
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/applyCheckStatisticAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String applyCheckStatisticAsync(@JSONRequestBody String request);

    /**
     * 全电发票--申请勾选统计反馈
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/applyCheckStatisticAsyncFeedback", method = RequestMethod.GET)
    String applyCheckStatisticAsyncFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 全电发票--确认勾选统计
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/confirmCheckStatisticAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String confirmCheckStatisticAsync(@JSONRequestBody String request);

    /**
     * 全电发票--确认勾选统计反馈
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/confirmCheckStatisticAsyncFeedback", method = RequestMethod.GET)
    String confirmCheckStatisticAsyncFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 全电发票--撤销勾选统计
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/cancelCheckStatisticAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String cancelCheckStatisticAsync(@JSONRequestBody String request);

    /**
     * 全电发票--撤销勾选统计反馈
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/cancelCheckStatisticAsyncFeedback", method = RequestMethod.GET)
    String cancelCheckStatisticAsyncFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 全电发票--撤销勾选统计确认
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/cancelConfirmedCheckStatisticAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String cancelConfirmedCheckStatisticAsync(@JSONRequestBody String request);

    /**
     * 全电发票--撤销勾选统计确认反馈
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/cancelConfirmedCheckStatisticAsyncFeedback", method = RequestMethod.GET)
    String cancelConfirmedCheckStatisticAsyncFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 全电发票--查询不抵扣勾选发票
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/queryNotDeductionAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String queryNotDeductionAsync(@JSONRequestBody String request);

    /**
     * 全电发票--查询不抵扣勾选发票反馈
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/queryNotDeductionAsyncFeedback", method = RequestMethod.GET)
    String queryNotDeductionAsyncFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 全电发票--查询不抵扣勾选记录
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/queryNotDeductionCheckRecordAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String queryNotDeductionCheckRecordAsync(@JSONRequestBody String request);

    /**
     * 全电发票--查询不抵扣勾选记录反馈
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/queryNotDeductionCheckRecordAsyncFeedback", method = RequestMethod.GET)
    String queryNotDeductionCheckRecordAsyncFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 全电发票--不抵扣类发票抵扣勾选/撤销抵扣勾选
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/notDeductionCheckAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String notDeductionCheckAsync(@JSONRequestBody String request);

    /**
     * 全电发票--不抵扣类发票抵扣勾选/撤销抵扣勾选反馈
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/notDeductionCheckAsyncFeedback", method = RequestMethod.GET)
    String notDeductionCheckAsyncFeedback(@RequestParam(value = "requestId") String requestId);

}
