package cn.com.servyou.service.invoice.digitization;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

/**
 * @author sunjl
 * @since 20230323
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface QueryRequest {

    /**
     * 全电发票--获取身份认证二维码
     *
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/queryAuthQrCodeAsync", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String queryAuthQrCodeAsync(@JSONRequestBody String request);

    /**
     * 全电发票--获取身份认证二维码反馈
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/queryAuthQrCodeFeedback", method = RequestMethod.GET)
    String queryAuthQrCodeFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 全电发票--查询身份认证二维码认证状态反馈
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/queryScanningStateFeedback", method = RequestMethod.GET)
    String queryScanningStateFeedback(@RequestParam(value = "rzid") String rzid);

    /**
     * 全电发票--查询已开具发票信息
     *
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/queryBillingInvoiceAsync", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String queryBillingInvoiceAsync(@JSONRequestBody String request);

    /**
     * 全电发票--查询已开具发票信息反馈
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/queryBillingInvoiceAsyncFeedback", method = RequestMethod.GET)
    String queryBillingInvoiceAsyncFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 全电发票--全量发票查询
     *
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/queryFullInvoiceAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String queryFullInvoiceAsync(@JSONRequestBody String request);

    /**
     * 全电发票--全量发票查询反馈
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/queryFullInvoiceAsyncFeedback", method = RequestMethod.GET)
    String queryFullInvoiceAsyncFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 全电发票--下载发票文件
     *
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/downloadFileAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String downloadFileAsync(@JSONRequestBody String request);

    /**
     * 全电发票--下载发票文件反馈
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/downloadFileAsyncFeedback", method = RequestMethod.GET)
    String downloadFileAsyncFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 全电发票--查询数据概览
     *
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/queryBillingDataOverviewAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String queryBillingDataOverviewAsync(@JSONRequestBody String request);

    /**
     * 全电发票--查询数据概览反馈
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/queryBillingDataOverviewAsyncFeedback", method = RequestMethod.GET)
    String queryBillingDataOverviewAsyncFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 全电发票--发票邮箱交付
     *
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/mailSendAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String mailSendAsync(@JSONRequestBody String request);

    /**
     * 全电发票--发票邮箱交付反馈
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/mailSendFeedback", method = RequestMethod.GET)
    String mailSendFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 全电发票--查询发票入账标识
     *
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/queryAccountStatusAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String queryAccountStatusAsync(@JSONRequestBody String request);

    /**
     * 全电发票--查询发票入账标识反馈
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/queryAccountStatusFeedback", method = RequestMethod.GET)
    String queryAccountStatusFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 全电发票--保存发票入账状态
     *
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/saveAccountStatusAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String saveAccountStatusAsync(@JSONRequestBody String request);

    /**
     * 全电发票--保存发票入账状态反馈
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/saveAccountStatusFeedback", method = RequestMethod.GET)
    String saveAccountStatusFeedback(@RequestParam(value = " requestId") String requestId);

}
