package cn.com.servyou.service.invoice.digitization;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

/**
 * @author sunjl
 * @since 20230420
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface RedInvoiceBillingRequest {

    /**
     * 字发票--提交红字发票确认单
     *
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/submitRedInvoiceVoucherAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String submitRedInvoiceVoucherAsync(@JSONRequestBody String request);

    /**
     * 数字发票--提交红字发票确认单反馈
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/submitRedInvoiceVoucherFeedback", method = RequestMethod.GET)
    String submitRedInvoiceVoucherFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 字发票--查询红字确认信息详情
     *
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/queryRedInvoiceVoucherDetailAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String queryRedInvoiceVoucherDetailAsync(@JSONRequestBody String request);

    /**
     * 数字发票--查询红字确认信息详情反馈
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/queryRedInvoiceVoucherDetailFeedback", method = RequestMethod.GET)
    String queryRedInvoiceVoucherDetailFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 字发票--红字发票开具
     *
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/redInvoiceBillingAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String redInvoiceBillingAsync(@JSONRequestBody String request);

    /**
     * 数字发票--红字发票开具反馈
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/redInvoiceBillingFeedback", method = RequestMethod.GET)
    String redInvoiceBillingFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 字发票--撤销红字确认信息
     *
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/revokeRedInvoiceVoucherAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String revokeRedInvoiceVoucherAsync(@JSONRequestBody String request);

    /**
     * 数字发票--撤销红字确认信息反馈
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/revokeRedInvoiceVoucherFeedback", method = RequestMethod.GET)
    String revokeRedInvoiceVoucherFeedback(@RequestParam(value = "requestId") String requestId);

}
