package cn.com.servyou.service.invoice.digitization;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

/**
 * @author rjq
 * @since 20230323
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface SubscribeRequest {
    /**
     * 全电发票--服务开通
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/subscribeAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String subscribeAsync(@JSONRequestBody String request);

    /**
     * 全电发票--服务开通反馈
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/subscribeAsyncFeedback", method = RequestMethod.GET)
    String subscribeAsyncFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 全电发票--开启/关闭自动续订
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/updateAutoRenewalAsync", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String updateAutoRenewalAsync(@JSONRequestBody String request);

    /**
     * 全电发票--开启/关闭自动续订反馈
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/updateAutoRenewalAsyncFeedback", method = RequestMethod.GET)
    String updateAutoRenewalAsyncFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 全电发票--订阅信息查询
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/ets/invoice/digitization/querySubscribeData", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String querySubscribeData(@JSONRequestBody String request);

}
