package cn.com.servyou.service.ntax;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.common.SingleCustomerBaseRequest;
import cn.com.servyou.dto.ntax.BatchResultVO;
import cn.com.servyou.dto.ntax.CompanySNLocalTaxDeclareResultVO;
import cn.com.servyou.dto.ntax.QuerySNLocalTaxRequest;
import cn.com.servyou.dto.ntax.QuerySNLocalTaxResultVO;
import cn.com.servyou.dto.ntax.QueryTaxInitialResultVO;
import cn.com.servyou.dto.ntax.RefreshDeclarationResultVO;
import cn.com.servyou.dto.ntax.SNLocalTaxDeclareRequestVO;
import cn.com.servyou.dto.ntax.VATDeclareRequest;
import cn.com.servyou.dto.ntax.VATDeclareResultVO;
import cn.com.servyou.dto.ntax.VATPayRequest;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface NTaxDeclareRequest {

    /**
     * 增值税申报
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/declareVAT", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<AsyncResult> declareVAT(@JSONRequestBody VATDeclareRequest vatDeclareRequest);

    /**
     * 获取增值税申报反馈
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/getVATDeclareFeedback", method = RequestMethod.GET)
    ApiResponse<VATDeclareResultVO> getVATDeclareFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 增值税缴款
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/payVAT", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<AsyncResult> payVAT(@JSONRequestBody VATPayRequest vatPayRequest);

    /**
     * 获取增值税缴款结果
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/getVATPayFeedback", method = RequestMethod.GET)
    ApiResponse<VATDeclareResultVO> getVATPayFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 查询清册
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/refreshDeclarationInfo", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<AsyncResult> refreshDeclarationInfo(@JSONRequestBody VATPayRequest vatPayRequest);

    /**
     * 获取查询清册结果
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/refreshDeclarationInfoFeedback", method = RequestMethod.GET)
    ApiResponse<RefreshDeclarationResultVO> refreshDeclarationInfoFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 陕西水利基金申报
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/declareSNLocalTax", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> declareSNLocalTax(@JSONRequestBody SNLocalTaxDeclareRequestVO snLocalTaxDeclareRequestVO);

    /**
     * 获取增值税申报反馈
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/getSNLocalTaxDeclareFeedback", method = RequestMethod.GET)
    ApiResponse<BatchResultVO<CompanySNLocalTaxDeclareResultVO>> getSNLocalTaxDeclareFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 查询陕西水利基金申报清册
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/querySNLocalTax", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<QuerySNLocalTaxResultVO> querySNLocalTax(@JSONRequestBody QuerySNLocalTaxRequest request);

    /**
     * 下载核定
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/queryTaxInitial", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> queryTaxInitial(@JSONRequestBody SingleCustomerBaseRequest request);

    /**
     * 下载核定反馈
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/getQueryTaxInitialFeedback", method = RequestMethod.GET)
    ApiResponse<QueryTaxInitialResultVO> getQueryTaxInitialFeedback(@RequestParam(value = "requestId") String requestId);

}
