package cn.com.servyou.service.ntax;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.common.MultiCustomerBaseRequest;
import cn.com.servyou.dto.common.SingleCustomerBaseRequest;
import cn.com.servyou.dto.ntax.BatchGenerateBankPaymentVoucherRequest;
import cn.com.servyou.dto.ntax.BatchQueryPaidInfoRequestVO;
import cn.com.servyou.dto.ntax.BatchQueryUnPaidInfoRequest;
import cn.com.servyou.dto.ntax.FdGenerateWithheldVoucherRequestVO;
import cn.com.servyou.dto.ntax.FdGenerateWithheldVoucherResultVO;
import cn.com.servyou.dto.ntax.GenerateBankPaymentVoucherResultVO;
import cn.com.servyou.dto.ntax.GetBankPaymentVoucherRequestVO;
import cn.com.servyou.dto.ntax.GetBankPaymentVoucherResultVO;
import cn.com.servyou.dto.ntax.NtaxBatchResultVO;
import cn.com.servyou.dto.ntax.PaidInfoResultVO;
import cn.com.servyou.dto.ntax.QueryDepositAccountResultVO;
import cn.com.servyou.dto.ntax.QueryPaymentStateInfoRequestVO;
import cn.com.servyou.dto.ntax.QueryPaymentStateInfoResultVO;
import cn.com.servyou.dto.ntax.QueryWithheldVoucherRequestVO;
import cn.com.servyou.dto.ntax.QueryWithheldVoucherResultVO;
import cn.com.servyou.dto.ntax.UnPaidInfoResultVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

/**
 * 增值税缴款
 *
 * @author rjq
 * @since 20220526
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface NTaxPaymentRequest {

    /**
     * 批量查询未缴款信息
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/batchQueryUnPaidInfo", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<AsyncResult> batchQueryUnPaidInfo(@JSONRequestBody MultiCustomerBaseRequest<BatchQueryUnPaidInfoRequest> request);

    /**
     * 获取批量查询未缴款信息反馈
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/getBatchQueryUnPaidInfoFeedback", method = RequestMethod.GET)
    public ApiResponse<NtaxBatchResultVO<UnPaidInfoResultVO>> getBatchQueryUnPaidInfoFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 批量查询已缴款信息
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/batchQueryPaidInfo", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<AsyncResult> batchQueryPaidInfo(@JSONRequestBody MultiCustomerBaseRequest<BatchQueryPaidInfoRequestVO> request);

    /**
     * 获取批量查询已缴款信息反馈
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/getBatchQueryPaidInfoFeedback", method = RequestMethod.GET)
    public ApiResponse<NtaxBatchResultVO<PaidInfoResultVO>> getBatchQueryPaidInfoFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 批量生成银行缴款凭证
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/batchGenerateBankPaymentVoucher", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> batchGenerateBankPaymentVoucher(@JSONRequestBody MultiCustomerBaseRequest<BatchGenerateBankPaymentVoucherRequest> request);

    /**
     * 获取批量生成银行缴款凭证反馈
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/getBatchGenerateBankPaymentVoucherFeedback", method = RequestMethod.GET)
    public ApiResponse<NtaxBatchResultVO<GenerateBankPaymentVoucherResultVO>> getBatchGenerateBankPaymentVoucherFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 查询银行账户信息（法电）
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/queryDepositAccount", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> queryDepositAccount(@JSONRequestBody SingleCustomerBaseRequest request);

    /**
     * 查询银行账户信息反馈（法电）
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/getQueryDepositAccountFeedback", method = RequestMethod.GET)
    ApiResponse<QueryDepositAccountResultVO> getQueryDepositAccountFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 查询缴款信息（法电）
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/queryPaymentInfo", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> queryPaymentInfo(@JSONRequestBody QueryPaymentStateInfoRequestVO request);

    /**
     * 查询缴款信息反馈（法电）
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/getQueryPaymentInfoFeedback", method = RequestMethod.GET)
    ApiResponse<QueryPaymentStateInfoResultVO> getQueryPaymentInfoFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 生成银行缴款凭证（法电）
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/getBankPaymentVoucher", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> getBankPaymentVoucher(@JSONRequestBody GetBankPaymentVoucherRequestVO request);

    /**
     * 生成银行缴款凭证反馈（法电）
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/getBankPaymentVoucherFeedback", method = RequestMethod.GET)
    ApiResponse<GetBankPaymentVoucherResultVO> getBankPaymentVoucherFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 待开具税款信息查询（法电）
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/queryPendingTaxInfo", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> queryPendingTaxInfo(@JSONRequestBody QueryWithheldVoucherRequestVO request);

    /**
     * 待开具税款信息查询反馈（法电）
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/getQueryPendingTaxInfoFeedback", method = RequestMethod.GET)
    ApiResponse<QueryWithheldVoucherResultVO> getQueryPendingTaxInfoFeedback(@RequestParam(value = "requestId") String requestId);

    /**
     * 完税证明开具&下载（法电）
     *
     * @param request
     * @return
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/getWithheldVoucher", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    ApiResponse<AsyncResult> getWithheldVoucher(@JSONRequestBody FdGenerateWithheldVoucherRequestVO request);

    /**
     * 完税证明开具&下载反馈（法电）
     *
     * @param requestId
     * @return
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/getWithheldVoucherFeedback", method = RequestMethod.GET)
    ApiResponse<FdGenerateWithheldVoucherResultVO> getWithheldVoucherFeedback(@RequestParam(value = "requestId") String requestId);

}
