package cn.com.servyou.service.ntax;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.ntax.CompanyNTAgreementVO;
import cn.com.servyou.dto.ntax.CompanyVATDeclareStateVO;
import cn.com.servyou.dto.ntax.GetReportRequestVO;
import cn.com.servyou.dto.ntax.GetReportResultVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface NTaxQueryRequest {
    /**
     * 获取单企业三方协议列表
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/getAgreementList", method = RequestMethod.GET)
    ApiResponse<CompanyNTAgreementVO> getAgreementList(@RequestParam(value = "nsrsbh") String nsrsbh,
                                                       @RequestParam(value = "areaid") String areaid,
                                                       @RequestParam(value = "djxhid") String djxhid);

    /**
     * 获取增值税申报状态
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/getVATDeclareState", method = RequestMethod.GET)
    ApiResponse<CompanyVATDeclareStateVO> getVATDeclareState(
            @RequestParam(value = "nsrsbh") String nsrsbh,
            @RequestParam(value = "areaid") String areaid,
            @RequestParam(value = "period") String period,
            @RequestParam(value = "djxhid") String registrationNumber);

    /**
     * 增值税报表明细查询
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/getReport", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<GetReportResultVO> getReport(@JSONRequestBody GetReportRequestVO getReportRequestVO);

}
