package cn.com.servyou.service.ntax;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.common.MultiCustomerBaseRequest;
import cn.com.servyou.dto.ntax.BatchGenerateWithheldVoucherRequest;
import cn.com.servyou.dto.ntax.NtaxBatchResultVO;
import cn.com.servyou.dto.ntax.WithheldVoucherVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface NTaxWithheldVoucherRequest {

    /**
     * 批量开具完税证明
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/generateWithheldVoucher", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<AsyncResult> generateWithheldVoucher(@JSONRequestBody MultiCustomerBaseRequest<BatchGenerateWithheldVoucherRequest> request);

    /**
     * 获取批量开具完税证明反馈
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/getGenerateWithheldVoucherFeedback", method = RequestMethod.GET)
    ApiResponse<NtaxBatchResultVO<WithheldVoucherVO>> getGenerateWithheldVoucherFeedback(@RequestParam(value = "requestId") String requestId);
}
