package cn.com.servyou.service.ntax;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.dto.ApiResponse;
import cn.com.servyou.dto.AsyncResult;
import cn.com.servyou.dto.ntax.NtaxAsyncInitFeedbackResultVO;
import cn.com.servyou.dto.ntax.NtaxAsyncInitRequestVO;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;
import cn.com.servyou.rmi.http.RequestParam;

/**
 * @author sunjl
 * @since 20220728
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface NtaxInitRequest {

    /**
     * 异步初始化
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/asyncInit", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    ApiResponse<AsyncResult> asyncInit(@JSONRequestBody NtaxAsyncInitRequestVO ntaxAsyncInitRequestVO);

    /**
     * 获取异步初始化反馈
     */
    @RequestMapping(value = "/gateway/ets/ntax/declare/getAsyncInitFeedback", method = RequestMethod.GET)
    public ApiResponse<NtaxAsyncInitFeedbackResultVO> getAsyncInitFeedback(@RequestParam(value = "requestId") String requestId);

}
