package cn.com.servyou.service.park;

import cn.com.servyou.constant.RMIConstant;
import cn.com.servyou.rmi.client.ServiceClient;
import cn.com.servyou.rmi.customization.annotations.ServyouSignature;
import cn.com.servyou.rmi.http.JSONRequestBody;
import cn.com.servyou.rmi.http.RequestMapping;
import cn.com.servyou.rmi.http.RequestMethod;

/**
 * @author sunjl
 * @since 20231026
 */
@ServiceClient(value = RMIConstant.SERVER_KEY_NAME)
@ServyouSignature
public interface TaxParkBusinessRequest {

    /**
     * 文件上传
     */
    @RequestMapping(value = "/gateway/ets/taxPark/upload", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String upload(@JSONRequestBody String request);

    /**
     * 用户协议数据采集
     */
    @RequestMapping(value = "/gateway/ets/taxPark/collectUserProtocolData", method = RequestMethod.POST, headers = {"Content-Type=application/json"})
    String collectUserProtocolData(@JSONRequestBody String request);

    /**
     * 资金流水采集
     */
    @RequestMapping(value = "/gateway/ets/taxPark/collectFundFlow", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String collectFundFlow(@JSONRequestBody String request);

    /**
     * 订单采集
     */
    @RequestMapping(value = "/gateway/ets/taxPark/collectOrder", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String collectOrder(@JSONRequestBody String request);

    /**
     * 获取实名认证跳转地址
     */
    @RequestMapping(value = "/gateway/ets/taxPark/getAuthenticateRealNameUrl", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String getAuthenticateRealNameUrl(@JSONRequestBody String request);

    /**
     * 获取实名认证结果
     */
    @RequestMapping(value = "/gateway/ets/taxPark/getAuthenticateRealNameResult", method = RequestMethod.POST, headers = { "Content-Type=application/json" })
    String getAuthenticateRealNameResult(@JSONRequestBody String request);

}
